﻿using System;
using System.Collections.Generic;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class GetProvidersStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (state.ServiceAppointment.Resources == null || state.ServiceAppointment.Resources.ToList().Count == 0) throw new Exception("Resources must be specified for all appointments");

            var bookedSysUsers = state.ServiceAppointment.Resources.Where(r => r.PartyId.LogicalName == "systemuser").ToList();

            var isStoreForward = state.ServiceAppointment.cvt_TelehealthModality ?? false;
            if (bookedSysUsers.Count == 0 && !isStoreForward) throw new Exception("Unable to retrieve Provider Data");

            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                //tsa is deprecated.  replacing with Scheduling Package(cvt_resourcepackage)
                //var tsa = srv.mcs_servicesSet.FirstOrDefault(t => t.Id == state.ServiceAppointment.mcs_relatedtsa.Id);
                var tsa = srv.cvt_resourcepackageSet.FirstOrDefault(t => t.Id == state.ServiceAppointment.cvt_relatedschedulingpackage.Id);
                //if (tsa == null) throw new Exception("No TSA is associated with the service activity");
                if (tsa == null) throw new Exception("No Scheduling Package is associated with the service activity");
                var parties = bookedSysUsers.Select(ap => ap.PartyId.Id);

                //Query for PRGs Listing the Provider as a user directly
                //var prgs = srv.cvt_providerresourcegroupSet.Where(prg => prg.cvt_RelatedTSAid.Id == tsa.Id && prg.cvt_RelatedUserId != null).Select(prg => prg.cvt_RelatedUserId.Id).ToList();

                var ps = srv.cvt_participatingsiteSet.Where(p => p.cvt_resourcepackage.Id == tsa.Id && p.cvt_providers != null).ToList();
                var providers = new List<Guid>();
                foreach (cvt_participatingsite pSite in ps)
                {
                    providers = srv.cvt_schedulingresourceSet.Where(s => s.cvt_participatingsite.Id == pSite.Id && (int)s.cvt_resourcetype.Value == (int)mcs_resourcetype.Provider).Select(s => s.cvt_tmpresource.Id).ToList();
                }

                //Query for PRGs Listing the Provider as a user through a group
                //var groupPrgs = srv.cvt_providerresourcegroupSet.Where(prg => prg.cvt_RelatedTSAid.Id == tsa.Id && prg.cvt_RelatedResourceGroupid != null).Select(prg => prg.cvt_RelatedResourceGroupid.Id).ToList();
                //var groupResourceUserIds = new List<Guid>();

                //foreach (var prg in groupPrgs)
                //{
                //    groupResourceUserIds = srv.mcs_groupresourceSet.Where(gr => gr.mcs_relatedResourceGroupId.Id == prg && gr.mcs_RelatedUserId != null).Select(gr => gr.mcs_RelatedUserId.Id).ToList();
                //}

                //Match Group PRGs with booked resources
                var matches = new List<Guid>();

                foreach (var party in parties)
                {
                    //if (groupResourceUserIds.Contains(party))
                    //    matches.Add(party);
                    if (providers.Contains(party))
                        matches.Add(party);
                }
                foreach (var match in matches)
                {
                    var user = srv.SystemUserSet.FirstOrDefault(u => u.Id == match);
                    state.SystemUsers.Add(user);
                }
            }
        }
    }
}